IF OBJECT_ID('UFD_EXP_CTB_MOV_CAIXA_CONSOLID') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_CAIXA_CONSOLID
	END
	
GO 
      
CREATE FUNCTION UFD_EXP_CTB_MOV_CAIXA_CONSOLID(@CD_EMP		INT,
											   @CD_FILIAL	INT,
											   @DT_INI		DATETIME,
											   @DT_FIM		DATETIME)		

RETURNS @RS_RETURN TABLE(
		CD_EMP		INT, 
		CD_FILIAL	INT, 
		DT_MOV		DATETIME, 
		VLR_DINH	MONEY, 
		VLR_CHQS	MONEY)
AS
BEGIN
	
	INSERT INTO @RS_RETURN
    SELECT 
    
		PDV_VD_FECHA_MOV_TES_DINH.CD_EMP, 
		PDV_VD_FECHA_MOV_TES_DINH.CD_FILIAL , 
		PDV_VD_FECHA_MOV_TES_DINH.DT_MOV, 
		PDV_VD_FECHA_MOV_TES_DINH.VLR_DINH, 
		PDV_VD_FECHA_MOV_TES_CHQS_VISTA.VLR_CHQS
		
    FROM PDV_VD_FECHA_MOV_TES		
		INNER JOIN PDV_VD_FECHA_MOV_TES_DINH ON 
			PDV_VD_FECHA_MOV_TES.CD_EMP = PDV_VD_FECHA_MOV_TES_DINH.CD_EMP AND
			PDV_VD_FECHA_MOV_TES.CD_FILIAL = PDV_VD_FECHA_MOV_TES_DINH.CD_FILIAL AND
			PDV_VD_FECHA_MOV_TES.DT_MOV = PDV_VD_FECHA_MOV_TES_DINH.DT_MOV
		INNER JOIN PDV_VD_FECHA_MOV_TES_CHQS_VISTA ON
			PDV_VD_FECHA_MOV_TES.CD_EMP = PDV_VD_FECHA_MOV_TES_CHQS_VISTA.CD_EMP AND
			PDV_VD_FECHA_MOV_TES.CD_FILIAL = PDV_VD_FECHA_MOV_TES_CHQS_VISTA.CD_FILIAL AND
			PDV_VD_FECHA_MOV_TES.DT_MOV = PDV_VD_FECHA_MOV_TES_CHQS_VISTA.DT_MOV 
	
	WHERE
		PDV_VD_FECHA_MOV_TES.CD_EMP			= @CD_EMP 
		AND PDV_VD_FECHA_MOV_TES.CD_FILIAL  = @CD_FILIAL
		AND PDV_VD_FECHA_MOV_TES.DT_MOV		BETWEEN @DT_INI AND @DT_FIM 
		
	RETURN
	
END			